#ifdef GL_ES
precision mediump float;
#endif

// output from the vertex shader (fragment color and texture coordinates)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

// uniform variables provided by the application
// uniform sampler2D CC_Texture0;

uniform float u_time;
#define WAVE 0

// main shader function
void main() {
	vec4 texel = texture2D(CC_Texture0, v_texCoord);
	vec4 color = v_fragmentColor * texel;
	float dist = v_fragmentColor.a;
	#if WAVE
	float wave_factor = 0.2 + sin(u_time * 2.0 - dist * 3.14 * 4.0) * 0.2;
	color.a += wave_factor * texel.a;
	#else
	float factor = sin(u_time * 2.0) * 0.2;
	color.a += factor * texel.a * (1.0 - dist);
	#endif
	gl_FragColor = color;
}
